/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.entity;

import com.sihenzhang.crockpot.effect.CrockPotEffects;
import com.sihenzhang.crockpot.entity.ChargeableMob;
import com.sihenzhang.crockpot.entity.CrockPotEntities;
import com.sihenzhang.crockpot.tag.CrockPotBlockTags;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class VoltGoat
extends Animal
implements ChargeableMob,
NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_CHARGE_TIME = SynchedEntityData.m_135353_(VoltGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(VoltGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final int PERSISTENT_CHARGE_TIME = 48000;
    @Nullable
    private UUID persistentAngerTarget;
    @Nullable
    private UUID lastLightningBolt;

    public VoltGoat(EntityType<? extends VoltGoat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new VoltGoatChargeGoal());
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new VoltGoatPanicGoal(1.5));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.4, 1.5));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ChargedVoltGoatAttackablePlayerGoal(this, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, arg_0 -> ((VoltGoat)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_CHARGE_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    @Override
    public int getRemainingPersistentChargeTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_CHARGE_TIME);
    }

    @Override
    public void setRemainingPersistentChargeTime(int pRemainingPersistentChargeTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_CHARGE_TIME, (Object)pRemainingPersistentChargeTime);
    }

    @Override
    public void startPersistentChargeTimer() {
        this.setRemainingPersistentChargeTime(48000);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pRemainingPersistentAngerTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pRemainingPersistentAngerTime);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pPersistentAngerTarget) {
        this.persistentAngerTarget = pPersistentAngerTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 10;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_144163_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_144166_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_144164_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_(SoundEvents.f_144151_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addPersistentChargeSaveData(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readPersistentChargeSaveData(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)CrockPotEntities.VOLT_GOAT.get()).m_20615_((Level)pLevel);
    }

    protected void m_8024_() {
        this.updatePersistentCharge();
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        super.m_8024_();
    }

    public int m_8085_() {
        return 15;
    }

    public void m_5616_(float pRotation) {
        int maxHeadYRot = this.m_8085_();
        float f = Mth.m_14118_((float)this.f_20883_, (float)pRotation);
        float f1 = Mth.m_14036_((float)f, (float)(-maxHeadYRot), (float)maxHeadYRot);
        super.m_5616_(this.f_20883_ + f1);
    }

    public SoundEvent m_7866_(ItemStack pStack) {
        return SoundEvents.f_144165_;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack stackInHand = pPlayer.m_21120_(pHand);
        if (stackInHand.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            pPlayer.m_5496_(SoundEvents.f_144168_, 1.0f, 1.0f);
            ItemStack milkBucket = ItemUtils.m_41813_((ItemStack)stackInHand, (Player)pPlayer, (ItemStack)Items.f_42455_.m_7968_());
            pPlayer.m_21008_(pHand, milkBucket);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult interactionResult = super.m_6071_(pPlayer, pHand);
        if (interactionResult.m_19077_() && this.m_6898_(stackInHand)) {
            this.m_9236_().m_6269_(null, (Entity)this, this.m_7866_(stackInHand), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)this.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
        }
        return interactionResult;
    }

    public void setLastLightningBolt(UUID lastLightningBolt) {
        this.lastLightningBolt = lastLightningBolt;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
        UUID uuid = pLightning.m_20148_();
        if (!uuid.equals(this.lastLightningBolt)) {
            this.startPersistentChargeTimer();
            this.setLastLightningBolt(uuid);
        }
    }

    public static boolean checkVoltGoatSpawnRules(EntityType<? extends Animal> pVoltGoat, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(CrockPotBlockTags.VOLT_GOATS_SPAWNABLE_ON) && VoltGoat.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    class VoltGoatChargeGoal
    extends Goal {
        VoltGoatChargeGoal() {
        }

        public boolean m_8036_() {
            return VoltGoat.this.m_7090_();
        }

        public void m_8056_() {
            VoltGoat.this.m_7292_(new MobEffectInstance((MobEffect)CrockPotEffects.CHARGE.get(), -1, 0, false, false));
        }

        public void m_8041_() {
            VoltGoat.this.m_21195_((MobEffect)CrockPotEffects.CHARGE.get());
        }
    }

    class VoltGoatPanicGoal
    extends PanicGoal {
        public VoltGoatPanicGoal(double pSpeedModifier) {
            super((PathfinderMob)VoltGoat.this, pSpeedModifier);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }

    static class ChargedVoltGoatAttackablePlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private int timestamp;

        public ChargedVoltGoatAttackablePlayerGoal(VoltGoat pMob, boolean pMustSee) {
            super((Mob)pMob, Player.class, pMustSee);
        }

        public boolean m_8036_() {
            return this.voltGoatCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.voltGoatCanTarget() && super.m_8045_();
        }

        public void m_8056_() {
            this.timestamp = this.f_26135_.f_19797_;
            super.m_8056_();
        }

        public void m_8041_() {
            if (this.f_26135_.m_21213_() < this.timestamp) {
                VoltGoat voltGoat = (VoltGoat)this.f_26135_;
                voltGoat.m_21662_();
            }
            super.m_8041_();
        }

        private boolean voltGoatCanTarget() {
            VoltGoat voltGoat = (VoltGoat)this.f_26135_;
            return voltGoat.m_7090_();
        }
    }
}

